local t = LoadFallbackB();

-- Marker
if GAMESTATE:IsCourseMode() == true then
t[#t+1] = LoadActor("course") .. {
	InitCommand=cmd(visible,GAMESTATE:IsCourseMode(););
	}
end

--- Banner
t[#t+1] = Def.ActorFrame {
	Def.ActorFrame { -- Color
		Def.Quad {
			InitCommand=cmd(zoomto,256,SCREEN_HEIGHT;horizalign,left;vertalign,top;x,SCREEN_LEFT;y,SCREEN_TOP;visible,not GAMESTATE:IsCourseMode(););
			OnCommand=cmd(diffuse,color("#303F9F");diffusealpha,0.7;addx,-256;decelerate,0.6;addx,256;);
			OffCommand=cmd(decelerate,0.5;addx,-256;);
		};
		Def.Quad {
			InitCommand=cmd(zoomto,256,256;horizalign,left;vertalign,top;x,SCREEN_LEFT;y,SCREEN_TOP+55;visible,not GAMESTATE:IsCourseMode(););
			OnCommand=cmd(diffuse,color("#2E3A85");diffusealpha,0.6;addx,-256;decelerate,0.6;addx,256;);
			OffCommand=cmd(decelerate,0.5;addx,-256;);
		};
	};
};

t[#t+1] = Def.Sprite {
		name="SongJacket";
        InitCommand=cmd(horizalign,left;vertalign,top;x,SCREEN_LEFT-256;y,SCREEN_TOP+55;); 
		OffCommand=cmd(decelerate,0.5;addx,-256;);
		OnCommand=cmd(decelerate,0.6;addx,256;);
		ChangedCommand=cmd(finishtweening;smooth,0.2;zoomx,0.8);
		TransitionCommand=cmd(finishtweening;zoomx,0.8;diffusealpha,0;decelerate,0.2;zoom,1;diffusealpha,1;);
        CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
        CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"); 
        SetCommand=function(self) 
            local song = GAMESTATE:GetCurrentSong(); 
			if song then
                if song:HasJacket() then
					self:playcommand("Changed")
                    self:Load(song:GetJacketPath())
                    self:scaletoclipped(256,256)
					self:playcommand("Transition")

                elseif song:HasBanner() then
					self:playcommand("Changed")
                    self:Load(song:GetBannerPath())
	                self:scaletoclipped(256,80)
					self:playcommand("Transition")
                else
					self:playcommand("Changed")
                    self:Load(THEME:GetPathG("Common fallback", "banner"))
					self:scaletoclipped(256,256)
					self:playcommand("Transition")
                end
			else
				self:diffusealpha(0)
            end
        end;
		};

if GAMESTATE:IsCourseMode() == false then
-- Yes. Preview videos.
 
t[#t+1] = Def.Sprite {
        name="PreviewVideo";
        InitCommand=cmd(scaletoclipped,256,256;horizalign,left;vertalign,top;x,SCREEN_LEFT;y,SCREEN_TOP+55;);
        CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
        OffCommand=cmd(decelerate,0.5;addx,-256;);
        SetCommand=function(self)
            local song = GAMESTATE:GetCurrentSong();
            if song then
					if song:HasPreviewVid() then
						self:diffusealpha(0)
						self:zoomx(1)
						self:Load(song:GetPreviewVidPath())
						self:sleep(0.8)
						self:decelerate(0.5)
						self:diffusealpha(1)
					else
						self:stoptweening()
						self:decelerate(0.3)
						self:zoomx(0)
						self:diffusealpha(0)
					end
				end
			end;
		};
			
--- Player pane
t[#t+1] = Def.ActorFrame {
	Def.ActorFrame { -- Color
		InitCommand=cmd(visible,not GAMESTATE:IsCourseMode());
		-- Underlay
		Def.Quad {
			InitCommand=cmd(zoomto,250,SCREEN_HEIGHT;horizalign,left;vertalign,top;x,SCREEN_RIGHT-246;y,SCREEN_CENTER_Y;diffuse,color("#303F9F");diffusealpha,0.3;);
			OnCommand=cmd(addx,250;decelerate,0.6;addx,-250;);

			OffCommand=cmd(decelerate,0.5;addx,256;);
		};
		-- 1p 2p
		Def.Quad {
			InitCommand=cmd(zoomto,250,SCREEN_HEIGHT/2;horizalign,left;vertalign,top;x,SCREEN_RIGHT-246;y,SCREEN_CENTER_Y;diffuse,ColorMidTone(PlayerColor(PLAYER_2));visible,GAMESTATE:IsHumanPlayer(PLAYER_2););
			OnCommand=cmd(addx,250;decelerate,0.6;addx,-250;diffusealpha,1;);
			PlayerJoinedMessageCommand=function(self,param)
				if param.Player == PLAYER_2 then
					(cmd(visible,true;addx,250;decelerate,0.2;addx,-250;diffusealpha,1))(self);
				end;
			end;
			OffCommand=cmd(decelerate,0.5;addx,256;);
		};
		Def.Quad {
			InitCommand=cmd(zoomto,250,SCREEN_HEIGHT/2+12;horizalign,left;vertalign,top;x,SCREEN_RIGHT-246;y,SCREEN_TOP;diffuse,ColorMidTone(PlayerColor(PLAYER_1));visible,GAMESTATE:IsHumanPlayer(PLAYER_1););
			OnCommand=cmd(addx,250;decelerate,0.6;addx,-250;diffusealpha,1;);
			PlayerJoinedMessageCommand=function(self,param)
				if param.Player == PLAYER_1 then
					(cmd(visible,true;addx,250;decelerate,0.2;addx,-250;diffusealpha,1))(self);
				end;
			end;
			OffCommand=cmd(decelerate,0.5;addx,256;);
		};
	};
};


-- Song Title/Genre

t[#t+1] = LoadFont("_roboto condensed light 24px") .. { 
          InitCommand=cmd(x,SCREEN_LEFT+15;y,SCREEN_CENTER_Y+170;maxwidth,220;horizalign,left;diffuse,color("#FFFFFF");zoom,0.5;uppercase,true;); 
		  OnCommand=cmd(addx,-10;diffusealpha,0;sleep,0.6;smooth,0.4;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
               local song = GAMESTATE:GetCurrentSong(); 
               if song then
					self:finishtweening();
					self:smooth(0.2);
					self:diffusealpha(0);
					self:addx(10);
                    self:settext(song:GetGenre()); 
                    self:playcommand("Refresh");
					(cmd(stoptweening;addx,-6;diffusealpha,0.0;smooth,0.2;addx,6;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh");
               end 
          end;
};

t[#t+1] = LoadFont("_roboto condensed light 24px") .. { 
          InitCommand=cmd(x,SCREEN_LEFT+15;y,SCREEN_CENTER_Y+83;maxwidth,220;horizalign,left;diffuse,color("#FFFFFF");zoom,0.5;uppercase,true;); 
		  OnCommand=cmd(addx,-10;diffusealpha,0;sleep,0.6;smooth,0.4;addx,10;diffusealpha,0.6;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
				self:settext("ARTIST");
				self:playcommand("Refresh");
          end;
};

t[#t+1] = LoadFont("_roboto condensed light 24px") .. { 
          InitCommand=cmd(x,SCREEN_LEFT+15;y,SCREEN_CENTER_Y+93;wrapwidthpixels,250;horizalign,left;vertalign,top;diffuse,color("#FFFFFF");zoom,0.75;uppercase,false;maxwidth,325;); 
		  BeginCommand=cmd(playcommand,"Set");
		  OnCommand=cmd(addx,-10;diffusealpha,0;sleep,0.6;smooth,0.4;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentSongChangedMessageCommand=cmd(playcommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(playcommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
               local song = GAMESTATE:GetCurrentSong(); 
               if song then 
					self:finishtweening();
					self:smooth(0.2);
					self:diffusealpha(0);
					self:addx(10);
                    self:settext(song:GetDisplayArtist()); 
                    self:playcommand("Refresh");
					(cmd(stoptweening;addx,-6;diffusealpha,0.0;smooth,0.2;addx,6;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh"); 
               end 
          end;
};


-- Difficulty numbers
t[#t+1] = LoadFont("_roboto condensed light 48px") .. { 
          InitCommand=cmd(x,SCREEN_RIGHT-190;y,SCREEN_CENTER_Y-160+12;horizalign,right;); 
		  OnCommand=cmd(diffusealpha,0;addx,-10;sleep,0.5;smooth,0.2;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set";playcommand,"Transition";); 
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP1 ~= nil then
					self:settext(stepsP1:GetMeter())
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end
};

t[#t+1] = LoadFont("_roboto condensed light 48px") .. { 
          InitCommand=cmd(x,SCREEN_RIGHT-190;y,SCREEN_CENTER_Y+160+12;horizalign,right;);
		  OnCommand=cmd(diffusealpha,0;addx,-10;sleep,0.5;smooth,0.2;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set";playcommand,"Transition";); 
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self)
			stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP2 ~= nil then
					self:settext(stepsP2:GetMeter())
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end
};

t[#t+1] = LoadActor("_p1pane") .. {
	InitCommand=cmd(x,SCREEN_RIGHT-220;y,SCREEN_CENTER_Y-120+12;horizalign,left;visible,GAMESTATE:IsHumanPlayer(PLAYER_1););
	OnCommand=cmd(diffusealpha,0;sleep,0.5;decelerate,0.2;diffusealpha,1);
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_1 then
				(cmd(visible,true;diffusealpha,0;sleep,0.5;decelerate,0.2;diffusealpha,1))(self);
			end;
		end;
	}

t[#t+1] = LoadActor("_p2pane") .. {
	InitCommand=cmd(x,SCREEN_RIGHT-220;y,SCREEN_CENTER_Y+90;horizalign,left;visible,GAMESTATE:IsHumanPlayer(PLAYER_2););
	OnCommand=cmd(diffusealpha,0;sleep,0.5;decelerate,0.2;diffusealpha,1);
	PlayerJoinedMessageCommand=function(self,param)
		if param.Player == PLAYER_2 then
				(cmd(visible,true;diffusealpha,0;sleep,0.5;decelerate,0.2;diffusealpha,1))(self);
			end;
		end;
	}
-- Difficulty name
t[#t+1] = LoadFont("Common bold") .. { 
          InitCommand=cmd(x,SCREEN_RIGHT-180;y,SCREEN_CENTER_Y-167+12;horizalign,left;);
		  OnCommand=cmd(diffusealpha,0;addx,-10;sleep,0.5;smooth,0.2;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set";playcommand,"Transition";); 
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set");
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
          SetCommand=function(self)
			stepsP1 = GAMESTATE:GetCurrentSteps(PLAYER_1)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP1 ~= nil then
					local st = stepsP1:GetStepsType();
					local diff = stepsP1:GetDifficulty();
					local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
					local cd = GetCustomDifficulty(st, diff, courseType);
					self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
					self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString(diff)));
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end
};

t[#t+1] = LoadFont("Common bold") .. { 
          InitCommand=cmd(x,SCREEN_RIGHT-180;y,SCREEN_CENTER_Y+167+12;horizalign,left;); 
		  OnCommand=cmd(diffusealpha,0;addx,-10;sleep,0.5;smooth,0.2;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set";playcommand,"Transition";); 
		  PlayerJoinedMessageCommand=cmd(playcommand,"Set";diffusealpha,0;smooth,0.3;diffusealpha,1;);
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set");
		  TransitionCommand=cmd(finishtweening;diffusealpha,0;addy,-3;smooth,0.2;diffusealpha,1;addy,3;);
          SetCommand=function(self)
			stepsP2 = GAMESTATE:GetCurrentSteps(PLAYER_2)
			local song = GAMESTATE:GetCurrentSong();
			if song then 
				if stepsP2 ~= nil then
					local st = stepsP2:GetStepsType();
					local diff = stepsP2:GetDifficulty();
					local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
					local cd = GetCustomDifficulty(st, diff, courseType);
					self:diffuse(ColorLightTone(CustomDifficultyToColor(cd)));
					self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString(diff)));
				else
					self:settext("")
				end
			else
				self:settext("")
			end
          end
};
	
-- Sort order 

t[#t+1] = LoadActor("_sortpane") .. {
		InitCommand=cmd(x,SCREEN_RIGHT-110;y,SCREEN_CENTER_Y+12);
		OnCommand=cmd(zoomx,0;diffusealpha,0;decelerate,0.3;diffusealpha,1;zoomx,1.0);
		OffCommand=cmd(smooth,0.2;diffusealpha,0;addx,4);
	};

t[#t+1] = LoadFont("Common normal") .. { 
          InitCommand=cmd(x,SCREEN_RIGHT-150;y,SCREEN_CENTER_Y+12;maxwidth,SCREEN_WIDTH;horizalign,left;diffuse,color("#212121");zoom,0.75;uppercase,true;visible,not GAMESTATE:IsCourseMode(););
		  OnCommand=cmd(diffusealpha,0;sleep,0.3;smooth,0.2;diffusealpha,1);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          SortOrderChangedMessageCommand=cmd(playcommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
               local sortorder = GAMESTATE:GetSortOrder(); 
               if sortorder then
					self:finishtweening();
					self:smooth(0.2);
					self:diffusealpha(0);
					self:addx(6);
                    self:settext(SortOrderToLocalizedString(sortorder)); 
                    self:playcommand("Refresh");
					(cmd(stoptweening;addx,-6;diffusealpha,0.0;smooth,0.2;addx,6;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh");
               end 
          end;
};	

t[#t+1] = LoadFont("_roboto condensed light 24px") .. { 
		  InitCommand=cmd(x,SCREEN_LEFT+210-30;y,SCREEN_CENTER_Y+190;horizalign,left;zoom,0.8;diffuse,color("#FFFFFF");visible,not GAMESTATE:IsCourseMode();); 
		  OnCommand=cmd(diffusealpha,0;sleep,0.6;addx,-10;smooth,0.4;addx,10;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          BeginCommand=cmd(playcommand,"Set"); 
          SetCommand=function(self) 
				self:settext("BPM");
          end;
};


t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(horizalign,center;x,SCREEN_RIGHT-210;y,SCREEN_CENTER_Y+12);
	CurrentSongChangedMessageCommand=cmd(playcommand,"Pop");
	PopCommand=cmd(finishtweening;decelerate,0.1;zoom,0.92;smooth,0.2;zoom,1);
	LoadActor("_circle") .. {
		InitCommand=cmd(zoom,0.3);
		OnCommand=cmd(addx,-10;diffusealpha,0;smooth,0.2;diffusealpha,1;addx,10;);
		OffCommand=cmd(sleep,0.5;smooth,0.1;zoom,0.2;smooth,0.2;diffusealpha,0;zoom,0.4);
	};
	LoadActor("_brightcircle") .. {
		InitCommand=cmd(zoom,0.3;diffusealpha,0);
		CurrentSongChangedMessageCommand=cmd(playcommand,"Pop");
		PopCommand=cmd(finishtweening;diffusealpha,0;zoom,0;accelerate,0.2;zoom,0.3;diffusealpha,0.3;smooth,0.2;diffusealpha,0);
	};
	LoadActor("_arrow") .. {
		InitCommand=cmd(zoom,0.3;zoomx,-0.3;);
		OnCommand=cmd(addx,-10;diffusealpha,0;smooth,0.2;diffusealpha,1;addx,10;);
		OffCommand=cmd(smooth,0.4;rotationz,90;smooth,0.3;diffusealpha,0;addy,-10);
	};
};

end;

t[#t+1] = StandardDecorationFromFileOptional("DifficultyList","DifficultyList");
t[#t+1] = StandardDecorationFromFileOptional("StageDisplay","StageDisplay");
t[#t+1] = StandardDecorationFromFileOptional("SongTime","SongTime") .. {
	SetCommand=function(self)
		local curSelection = nil;
		local length = 0.0;
		if GAMESTATE:IsCourseMode() then
			self:settext("");
		else
			curSelection = GAMESTATE:GetCurrentSong();
			self:playcommand("Reset");
			if curSelection then
				length = curSelection:MusicLengthSeconds();
				if curSelection:IsLong() then
					self:playcommand("Long");
				elseif curSelection:IsMarathon() then
					self:playcommand("Marathon");
				else
					self:playcommand("Reset");
				end
			else
				length = 0.0;
				self:playcommand("Reset");
			end;
			self:settext( SecondsToMSS(length) );
		end;
	end;
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
};
t[#t+1] = StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay");

return t